<?php
require_once 'setting/setting.php'; 

// Adding Meta container in admin shop_order pages
add_action('add_meta_boxes', 'chabock_add_meta_boxes');
function chabock_add_meta_boxes()
{
    add_meta_box(
        'chabock_add_meta_boxes',
        'ارسال سفارش به روش چابک',
        'chabock_fields_for_packaging',
        'shop_order',
        'side',
        'high'
    );

}

function chabock_fields_for_packaging($post)
{
    global $woocommerce, $post, $current_user;
    $order_id = intval($post->ID);

    if(!get_post_meta($order_id, 'tracking_code_chabok', true)){
        
        $order = wc_get_order($order_id);
        $order_data = $order->get_data();

        $reference = $order_id . '111' . rand(99, 999);

        $date = $order->get_date_paid('date_paid') ? $order->get_date_paid('date_paid')->date('Y-m-d') : $order_data['date_created']->date('Y-m-d');
        $order_total = $order_data['total'];

        //PRICE_CURRENCY_RIAL = 1 is Rial  and 0 is Toman
        $value      = PRICE_CURRENCY_RIAL ? $order_total : $order_total*10;;
        $person     = $order_data['billing']['first_name'] . ' ' . $order_data['billing']['last_name'];
        $city_no    = $order_data['billing']['city'];
        $mobile     = $order_data['billing']['phone'];
        $email      = $order_data['billing']['email'];
        $address    = $order_data['billing']['address_1'];
        $postcode   = $order_data['billing']['postcode'];
        $note       = $order_data['customer_note'];

        $order_items  = $order->get_items();
        $total_qty    = 0;
        $total_weight = 0;
        $categories = '';
        foreach ($order_items as $item_id => $product_item) {
            $product_id    = $product_item['product_id'];
            $product = wc_get_product($product_id);
            if (!$product) continue;
            $product_weight  = $product->get_weight() ? $product->get_weight() : 1;
            $quantity        = $product_item->get_quantity();
            $total_qty      += $quantity;
            $total_weight   += floatval($product_weight * $quantity);
            $terms = get_the_terms($product->get_id(), 'product_cat');

            $categories .= reset($terms)->name . ' / ';
        }

        //WEIGHT_UNIT_KILO = 1 is Kilogram and 0 is Gram
        $weight = WEIGHT_UNIT_KILO ? $total_weight : $total_weight/1000;
        $content = $categories;

        switch (CHABOK_SERVICE) {
            case '0':
                $service = "1";
                break;
            case '1':
                $service = "6";
                break;
            case '2':
                $service = "35";
                break;
        }

        $orderData = [
            'order_id' => $order_id,
            'reference' => $reference,
            'date' => $date,
            'value' => $value,
            'person' => $person,
            'city_no' => $city_no,
            'mobile' => $mobile,
            'email' => $email,
            'address' => $address,
            'postcode' => $postcode,
            'weight' => $weight,
            'content' => $content,
            'service' => $service,
            'assign_piece' => 1,
            'note' => $note,
        ];

        
        if ( CHABOK_DELIVERY_ONLY_TEHRAN == 'no' || $city_no == 'تهران') {
            render_form_call_api($orderData);
        } else {
            echo '<table class="sending_orders_table remove" style="width:100%">
                    <tr>
                        <th>پیام</th>
                    </tr>
                    <tr>
                        <td>روش ارسال چابک تنها درمناطق 22 گانه تهرن فعال است. برای فعال کردن سایر شهرها به بخش تنظیمات چابک بروید.!</td>
                    </tr>
                </table>';
        }

    }//end if add meta box when barcode is null
}

function add_chabock_form_function()
{    
    if (isset($_POST['add_chabock'])) {
 
        $cod = (isset($_POST['order_cod']) && !empty($_POST['order_cod'])) ? intval(trim($_POST['order_cod'])) : 0;
        $weight = (isset($_POST['order_weight']) && !empty($_POST['order_weight'])) ? intval(trim($_POST['order_weight'])) : $_POST['weight'];
        $assign_piece = (isset($_POST['order_assign_piece']) && !empty($_POST['order_assign_piece'])) ? intval(trim($_POST['order_assign_piece'])) : $_POST['assign_piece'];

        $order_id = $_POST['order_id'];
        $reference = $_POST['reference'];
        $date = $_POST['date'];
        $service = $_POST['service'];
        $value =  $_POST['value'];
        $person = $_POST['person'];
        $city = $_POST['city_no'];
        $mobile =  $_POST['mobile'];   
        $email =  $_POST['email'];
        $address =  $_POST['address'];
        $postcode =  $_POST['postcode'];
        $content =  $_POST['content'];
        $note = $_POST['note']; 

        $city_no = find_city_chabok($city);
        if(!$city_no){
            update_post_meta($order_id, 'error_api_chabok',  'حمل و نقل به این شهر امکان پذیر  نیست' );
            header("location:" . $_SERVER['HTTP_REFERER']);
            exit();
        }

        $user = new stdClass();
        $user->username = CHABOK_USERNAME;
        $user->password = CHABOK_PASSWORD;

        $cn = new stdClass();
        $cn->reference = $reference;
        $cn->date = $date;
        $cn->assinged_pieces = $assign_piece;
        $cn->service = $service;
        $cn->value = $value;
        $cn->payment_term = 0;
        $cn->weight = $weight;  
        $cn->content = $content;   
        $cn->note = $note;
        $cn->inv_value = $cod;

        $sender = new stdClass();
        $sender->person = STORE_NAME;
        $sender->company = STORE_NAME;
        $sender->city_no = find_city_chabok(STORE_CITY);
        $sender->telephone = STORE_PHONE;
        $sender->mobile = STORE_PHONE;
        $sender->email = STORE_EMAIL;
        $sender->address = STORE_ADDRESS;

        $receiver = new stdClass();
        $receiver->person = $person;
        $receiver->city_no = $city_no;
        $receiver->telephone = $mobile;
        $receiver->mobile = $mobile;
        $receiver->email = $email;
        $receiver->address = $address;
        $receiver->postcode = $postcode;

        $bulk = array();
        $bulkItem = new stdClass();
        $bulkItem->cn = $cn;
        $bulkItem->sender = $sender;
        $bulkItem->receiver = $receiver;
        $bulk[] = $bulkItem;
  
        $data = new stdClass();
        $data->user = $user;
        $data->bulk = $bulk;  
        $json_data = json_encode($data);
        
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => CHABOK_API."/bulk_import",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => array('input' => $json_data),
			CURLOPT_HTTPHEADER => array(
				'Content-Type: multipart/form-data'
			)
        ));
		$response = curl_exec($curl);

		$error = curl_error($curl);
		$status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);

		if ($error && $status_code !== 200) {
			var_dump($error);  
			return false;
		} else {

			$result = json_decode($response, true);
			if($result['result']){
				$tracking = $result["objects"]["result"][0]["tracking"];
				update_post_meta($order_id, 'tracking_code_chabok', $tracking);
				update_post_meta($order_id, 'puiw_invoice_track_id', $tracking);
				update_post_meta($order_id, 'order_result_chabok', 'true');
			}else{
				$msg = $result['message'];
				update_post_meta($order_id, 'error_api_chabok',  $msg );
				update_post_meta($order_id, 'order_result_chabok', 'false');
			}

		}
		
		header("location:" . $_SERVER['HTTP_REFERER']);
		exit();
	}

}

add_chabock_form_function();


function find_city_chabok($city_name)
{
    $request = file_get_contents(CITY_PATH);
    $request_array = json_decode($request, true);

    foreach ($request_array as $province => $cities) {
        $city_col = array_search($city_name, array_column($cities, 'name'));
        if ($city_col !== false && $cities[$city_col]['name'] == $city_name ) {
            return $cities[$city_col]['chbkCode']; 
        }
    }

    return null; 
}
function render_form_call_api($orderData) {
    ?>
    <style>
        form.api-form {
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            width: 300px;
        }

        input[type="text"] {
            width: 100%;
            padding: 5px;
            margin: 10px 0;
            border: 1px solid #ccc;
            border-radius: 4px;
            transition: border-color 0.3s;
        }

        input[type="text"]:focus {
            border-color: green;
            outline: none;
        }

        .button-primary {
            border: none !important;
            border-radius: 4px !important;
            padding: 5px !important;
            cursor: pointer;
            width: 100% !important;
            transition: background 0.3s;
        }

        .button-primary:hover {
            background: darkgreen;
        }
    </style>
    <form class="api-form" method="POST">
        <input type="text" id="order_cod" name="order_cod" placeholder="مبلغ cod را وارد  کنید" />
        <input type="text" id="order_weight" name="order_weight" placeholder="وزن اقلام رابه کیلوگرم وارد کنید" />
        <input type="text" id="order_assign_piece" name="order_assign_piece" placeholder="تعداد بسته را به عدد وارد کنید." />
        <?php foreach ($orderData as $key => $value): ?>
            <input type="hidden" name="<?= htmlspecialchars($key) ?>" value="<?= htmlspecialchars($value) ?>" />
        <?php endforeach; ?>
        <input type="submit" class="button-primary" name="add_chabock" id="validate-submit-chabock" value="صدور بارنامه چابک" style="background: green;">
    </form>
    <?php
}

function show_tracking_code_or_message_chabok_order($order)
{
    $order_id = $order->get_id();
    global $PeproUltimateInvoice;
    $generator = $PeproUltimateInvoice->barcode;

    $trackingCode = get_post_meta($order_id, 'tracking_code_chabok', true);
    $errorApiMessage = get_post_meta($order_id, 'error_api_chabok', true);

    if ($trackingCode) {
        echo '<strong>شماره بارنامه</strong>';   
        
        if (is_plugin_active('pepro-ultimate-invoice/pepro-ultimate-invoice.php')) {
            $src = 'data:image/jpeg;base64,' . base64_encode($generator->getBarcode($trackingCode, $generator::TYPE_CODE_128));
            echo '<img alt="" class="barcode" style="width:150px;height:auto;display:block" src="' . $src . '">';
        }

        echo '<span style="text-align:center">' . esc_html($trackingCode) . '</span>';
        return;
    }

    if ($errorApiMessage && !$trackingCode) {
        echo '<div style="padding: 10px; color: #000; font-size: 15px; line-height: 20px;">
                <strong>بارنامه چابک دریافت نشد!</strong><br>
                <span style="text-align:center; color: red">' . esc_html($errorApiMessage) . '</span>
              </div>';
        return;
    }
}
// add_action('woocommerce_admin_order_data_after_billing_address', 'show_tracking_code_or_massage_chabok_order', 10, 1);


