<?php
function chabok_shipping_method()
{

    if (!class_exists('Chabok_Shipping_Method')) {

        class Chabok_Shipping_Method extends WC_Shipping_Method
        {

            public $free_fee = '';
            public $cart_total = 0;
            public $cart_weight = 0;
            public $is_available = true;
            public $base_cost;
            public $base_auto_cost;

            /**

             * Constructor for your shipping class

             *

             * @access public

             * @return void

             */

            public function __construct($instance_id = 0)
            {
                $this->id                 = 'chabok_shipping_method';
                $this->instance_id        = absint($instance_id);
                $this->method_title       = __('حمل و نقل چابک', 'chabokwc');

                $this->method_description = __('محاسبه خودکار حمل و نقل چابک', 'chabokwc');
                $this->supports = [
                    'shipping-zones',
                    'instance-settings',
                    'instance-settings-modal',
                ];
                $this->init();

                $this->enabled = isset($this->settings['enabled']) ? $this->settings['enabled'] : 'yes';

                $this->title = isset($this->settings['title']) ? $this->settings['title'] : __('حمل و نقل چابک', 'chabokwc');

                // add_action('woocommerce_update_order_review', array($this, 'calculate_shipping'), 20, 1);

            }

            /**
             * Init your settings
             *
             * @access public

             * @return void

             */

            function init()
            {
                $this->base_cost = intval($this->get_option('base_cost'));
                $this->base_auto_cost  = $this->get_option('base_auto_cost');
                // Load the settings API
                $this->instance_form_fields = [
                    'title' => [
                        'title'   => 'عنوان روش',
                        'type'    => 'text',
                        'default' => $this->method_title,
                    ],
                ];

                $this->init_form_fields();
                $this->instance_form_fields = apply_filters('chabok_method_fields', $this->instance_form_fields + [
                    'minimum_fee' => [
                        'title'       => 'حداقل خرید',
                        'type'        => 'text',
                        'description' => 'در صورتی که مبلغ سفارش کمتر از این مبلغ باشد، این روش حمل و نقل مخفی می شود.',
                        'default'     => 0,
                        'desc_tip'    => true,
                    ],
                    'free_fee'    => [
                        'title'       => 'آستانه حمل و نقل رایگان',
                        'type'        => 'text',
                        'description' => 'در صورتی که مبلغ سفارش بیشتر از این مبلغ باشد، هزینه حمل و نقل برای مشتری رایگان می شود.',
                        'default'     => '',
                        'desc_tip'    => true,
                    ],
                    'img_url'     => [
                        'title'       => 'تصویر روش حمل و نقل',
                        'type'        => 'text',
                        'description' => 'آدرس تصویر مورد نظر برای این روش حمل و نقل را وارد کنید',
                        'default'     => '',
                        'css'         => 'direction: ltr;',
                        'desc_tip'    => true,
                    ],
                ], $this);
                $this->title       = $this->get_option('title', $this->method_title);
                $this->minimum_fee = $this->get_option('minimum_fee', 0);
                $this->free_fee    = $this->get_option('free_fee', '');
                $this->cart_total  = isset(WC()->cart) ? WC()->cart->get_cart_contents_total() : 0;
                $this->cart_weight = 1;
                $this->init_settings();

                // Save settings in admin if you have any defined


                add_action('woocommerce_update_options_shipping_' . $this->id, array($this, 'process_admin_options'));
            }


            /**

             * Define settings field for this shipping

             * @return void

             */

            function init_form_fields()
            {

                $currency_symbol = get_woocommerce_currency_symbol();

                $this->instance_form_fields += [
                    'base_cost' => [
                        'title'       => 'هزینه پایه',
                        'type'        => 'price',
                        'description' => 'مبلغ حمل و نقل به روش چابک را به ' . $currency_symbol . ' وارد نمائید. برای محاسبه خودکار 0 بگذارید',
                        'default'     => 0,
                    ],
                ];
                $this->instance_form_fields += [
                    'base_auto_cost' => [
                        'title'       => 'هزینه پایه + خودکار',
                        'type'        => 'checkbox',
                        'description' => 'هزینه پایه با هزینه خودکار جمع می شود.',
                        'default'     => 'no',
                    ],
                ];
            }

            /**
             * This function is used to calculate the shipping cost. Within this function, we can check for weights, dimensions, and other parameters.
             *
             * @access public
             * @param mixed $package
             * @return void
             */


            public function calculate_shipping($package = [])
            {
                if ($this->free_shipping($package)) {
                    return;
                }

                // Check for error in session or cookie
                if (isset($_SESSION['chabock_error'])) {
                    $this->show_error_for_shippin($_SESSION['chabock_error'], $package);
                    return;
                }

                // Use the cookie for price if session is not set
                $price = isset($_SESSION['chabock_price']) ? intval($_SESSION['chabock_price']) : (isset($_COOKIE['chabock_price']) ? intval($_COOKIE['chabock_price']) : 0);

                if ($this->get_option('base_auto_cost') == 'yes') {
                    $cost = $price + intval($this->get_option('base_cost'));
                } else {
                    $cost = intval($this->get_option('base_cost'));
                }

                $this->add_rate_cost($cost, $package);
            }

            public function free_shipping($package = []): bool
            {

                $has_free_shipping = $this->free_fee !== '' && $this->free_fee <= $this->cart_total;
                $has_free_shipping = apply_filters('chabok_has_free_shipping', $has_free_shipping, $package, $this);

                if ($has_free_shipping) {

                    $this->add_rate_cost(0, $package);

                    return true;
                }

                return false;
            }
            public function add_rate_cost($cost, $package)
            {
                $rate =  [
                    'id' => $this->id,
                    'label' => $this->get_option('title'),
                    'cost'  => $cost,
                    'calc_tax' => 'per_item'
                ];

                $this->add_rate($rate);
            }
            public function show_error_for_shippin($error, $package)
            {
                $rate =  [
                    'id' => $this->id,
                    'label' => $error,
                    'cost'  => 0,
                    'calc_tax' => 'per_item'
                ];

                $this->add_rate($rate);
            }
            public function is_available($package): bool
            {

                $available = $this->is_enabled() && $this->is_available;

                if (empty($package)) {
                    $available = false;
                }

                if ($package['destination']['country'] != 'IR') {
                    $available = false;
                }

                if ($this->minimum_fee > $this->cart_total) {
                    $available = false;
                }

                $available = apply_filters('woocommerce_shipping_chabok_methods_is_available', $available, $package, $this);

                return apply_filters('woocommerce_shipping_' . $this->id . '_is_available', $available, $package, $this);
            }
            public function shipping_method_image($label, $method)
            {

                $method_id = str_replace(':', '_', $method->id);
                $option    = get_option("woocommerce_{$method_id}_settings");

                if (isset($option['img_url']) && !empty($option['img_url'])) {
                    return sprintf('<img src="%s" class="pws-method-image %s %s" style="max-width: 100px;display: inline;"/>', $option['img_url'], $method_id, strtok($method->id, ':')) . $label;
                }

                return $label;
            }
            public function find_city($city_name)
            {
                $request = file_get_contents(CITY_PATH);
                $request_array = json_decode($request, true);
                $cites = $request_array['objects']['city'];
                $city_col = array_search($city_name, array_column($cites, 'name'));
                return $cites[$city_col]['no'];
            }
        }
    }   
}


add_action('woocommerce_shipping_init', 'chabok_shipping_method');   

function add_chabok_shipping_method($methods)
{
    $methods['chabok_shipping_method'] = 'Chabok_Shipping_Method';
    return $methods;
}
add_filter('woocommerce_shipping_methods', 'add_chabok_shipping_method');

if(get_option('wc_chabok_delivery_only_teh') == 'yes'){

    add_action('woocommerce_after_checkout_form', 'conditionally_hide_show_chabok_checkout', 9999);
    function conditionally_hide_show_chabok_checkout()
    {
        wc_enqueue_js("jQuery('#billing_city').change(function() {
			if (jQuery(this).val() !== 'تهران' ) {
                console.log('city is not tehran');
                jQuery('#shipping_method').find('label[for='shipping_method_0_chabok_shipping_method').parent().hide();
			} else {
                console.log('city is tehran');
			    jQuery('#shipping_method').find('label[for='shipping_method_0_chabok_shipping_method').parent().show();
			}
		}).change();");



    ?>
        <script>
            jQuery(document).ready(function() {

                jQuery(document).ajaxStop(function() {

                    console.log(12121212);
                    var current_city = jQuery('#billing_city').val();
                    if (current_city == 'تهران') {
                    }
                });

                jQuery('form.checkout').on('change', 'input[name^="shipping_method"]', function() {

                });
            });
        </script>
    <?php
    }
}

