<?php

/**
 * افزونه پیشرو پست - چابک
 * Plugin Name: افزونه پست چابک
 * Plugin URI: #
 * Description: افزونه همگام سازی ووکامرس و چابک
 * Version: 4.1  
 * Author: Chabok 
 * Text Domain: chabokwc
 */

require_once 'setting/setting.php'; 

if (!defined('ABSPATH')) exit; // Exit if accessed directly
add_action('admin_notices', function () {

    if (!is_plugin_active('pepro-ultimate-invoice/pepro-ultimate-invoice.php') and current_user_can('activate_plugins')) {?>
        <div class="notice notice-error is-dismissible">
            <p>لطفا برای چاپ فاکتور افزونه pepro ultimate invoice را نصب و فعال کنید! </p>
        </div>
    <?php }
        
    if (!is_plugin_active('persian-woocommerce/persian-woocommerce.php') and current_user_can('activate_plugins')) {?>
        <div class="notice notice-error is-dismissible">
            <p>لطفا برای دریافت شهر و استان ها در صفحه چک اوت ووکامرس فارسی را نصب و فعال کنید!</p>
        </div>
    <?php }
                    
    if (file_exists(SERVICE_PATH)) {?>
        <div class="notice notice-success is-dismissible">
            <p>تبریک. شما تمام فایل های مورد نیاز چابک را دانلود کردید!</p>
        </div>
    <?php }
        
});

class Chabok_WC
{
    public function __construct()
    {
        ob_start();
        
        if( !headers_sent() && !session_id() ) {
            session_start();
        }
      
        $this->ajax_get_state();
        if (CHABOK_METHOD_ENABEL == 'yes') {
            require_once 'chabock-shipping.php';
        }

        add_filter('woocommerce_settings_tabs_array', array($this, 'add_settings_tab'), 50);
        add_action('woocommerce_settings_tabs_chabok_settings', array($this, 'settings_tab'));
        add_action('woocommerce_update_options_chabok_settings', array($this, 'update_settings'));

      
        if ( CHABOK_CALL_API_ONLY_IN_ORDER_DETAIL == 'no') {
            add_action('woocommerce_thankyou', array($this, 'send_order_to_chabok'));
        }else{
            if (is_admin()) {
                require_once 'chabock-order-details.php';
            }
        }

        add_action("wp_ajax_chabok_ajax", array($this, "chabok_ajax"));
        add_action("wp_ajax_nopriv_chabok_ajax", array($this, "chabok_ajax"));
        add_action('woocommerce_admin_order_data_after_billing_address', array($this, 'show_tracking_code_in_order'), 10, 1);

        add_action('woocommerce_review_order_before_submit', array($this, 'ajax_get_city'));
        // add_action('woocommerce_update_order_review', array($this, 'ajax_get_city'));

        add_action("wp_ajax_get_quote", array($this, "get_quote"));
        add_action("wp_ajax_nopriv_get_quote", array($this, "get_quote"));

        add_action("wp_ajax_get_cities", array($this, "get_cities"));
        add_action("wp_ajax_nopriv_get_cities", array($this, "get_cities"));

        add_action("admin_footer", array($this, "admin_scripts"));
    }

    /**
     * add settings tab in woocommerce settings
     */
    public function add_settings_tab($settings_tabs)
    {
        $settings_tabs['chabok_settings'] = 'تنظیمات چابک';
        return $settings_tabs;
    }
    /**
     * settings tab content chabock
     */
    public function settings_tab()
    {
        woocommerce_admin_fields($this->get_settings());
    }

    public function update_settings()
    {
        woocommerce_update_options($this->get_settings());
    }

    public function get_settings(){
        $settings = array(
            'section_title' => array(
                'name' => 'تنظیمات چابک',
                'type' => 'title',
                'desc' => '',
                'id' => 'wc_chabok_settings_section_title'
            ),
            'chabok_username' => array(
                'name' => 'نام کاربری چابک:',
                'desc' => 'نام کاربری ورود به سامانه https://api.krch.ir/v1 را وارد نمایید.',
                'type' => 'text',
                'id' => 'wc_chabok_username'
            ),
            'chabok_password' => array(
                'name' => 'رمز عبور چابک:',
                'desc' => 'رمز عبور ورود به سامانه https://api.krch.ir/v1 را وارد نمایید.',
                'type' => 'text',
                'id' => 'wc_chabok_password'
            ),
            'chabok_api_address' => array(
                'name' => 'آدرس Api:',
                'type' => 'text',
                'id' => 'wc_chabok_api',
                'default' => 'https://api.krch.ir/v1',
                'placeholder' => 'https://api-XXX.chabok.app'
            ),
            'chabok_services' => array(
                'name' => 'نوع سرویس:',
                'type' => 'select',
                'id' => 'wc_chabok_services',
                'options'       => $this->get_services()
            ),
            'chabok_shipping_method_enabled' => array(
                'name'     => 'فعالسازی روش حمل و نقل چابک',
                'desc'     => 'درصورتیکه این گزینه را فعال کنید؛ روش حمل و نقل چابک به ووکامرس افزوده می شود و می توانید آن را مدیریت کنید و در غیر اینصورت در تمامی روش های حمل و نقل سفارش به چابک ارسال می شود.',
                'type' => 'checkbox',
                'default' => 'no',
                'id' => 'wc_chabok_shipping_method_enabled'
            ),
            'chabok_storename' => array(
                'name' => 'نام فروشگاه شما',
                'type' => 'text',
                'id' => 'wc_chabok_storename'
            ),
            'chabok_store_state' => array(
                'name' => 'استان محل فروشگاه',
                'type' => 'select',
                'id' => 'wc_chabok_store_state',
                'class' => 'wc-enhanced-select-nostd',
                'options'       => $this->get_states()
            ),
            'chabok_store_city' => array(
                'name' => 'شهر محل فروشگاه',
                'type' => 'select',
                'id' => 'wc_chabok_store_city',
                'class' => 'wc-enhanced-select-nostd',
                'options'       => $this->get_cities(),
            ),
            'chabok_store_city_name' => array(
                'type' => 'text',
                'class' => 'hidden',
                'id' => 'wc_chabok_store_city_name',
            ),
            'chabok_store_address' => array(
                'name' => 'آدرس فروشگاه',
                'type' => 'text',
                'id' => 'wc_chabok_store_address',
                'placeholder' => 'تهران، میدان آزادی'
            ),
            'chabok_store_postcode' => array(
                'name' => 'کد پستی فروشگاه',
                'type' => 'text',
                'id' => 'wc_chabok_store_postcode',
                'placeholder' => '1234567891'
            ),
            'chabok_storeemail' => array(
                'name' => 'ایمیل فروشگاه شما',
                'type' => 'text',
                'id' => 'wc_chabok_storeemail'
            ),
            'chabok_usertell' => array(
                'name' => 'تلفن فروشگاه شما',
                'type' => 'text',
                'id' => 'wc_chabok_usertell'
            ), 
            'chabok_weight_unit' => array( 
                'name' => 'واحد وزن:',
                'type' => 'select',
                'id' => 'wc_chabok_weight_unit',
                'options'       => ['گرم', 'کیلوگرم']
            ),
            'chabok_price_currency' => array(
                'name' => 'واحد قیمت:',
                'type' => 'select',
                'id' => 'wc_chabok_price_currency',
                'options'       => ['تومان', 'ریال']
            ),
            'chabok_barcode_in_order' => array(
                'name'     => 'روش فراخوانی بارنامه چابک',
                'desc'     => 'در صورت فعال کردن صدور بارنامه در جزییات سفارش انجام می شود',
                'type' => 'checkbox',
                'default' => 'no',
                'id' => 'wc_chabok_barcode_in_order'
            ),
            'chabok_delivery_only_teh' => array(
                'name'     => 'پوشش استانی چابک',
                'desc'     => 'در صورت فعال کردن, چابک تنها در مناطق 22 گانه تهران فعال خواهد بود',
                'type' => 'checkbox',
                'default' => 'no',
                'id' => 'wc_chabok_delivery_only_teh'
             ),   
            'section_end' => array(
                'type' => 'sectionend',
                'id' => 'wc_chabok_settings_section_end'
            )
        );
        return apply_filters('wc_chabok_settings', $settings);

    }

    public function get_states()
    {
        $request = file_get_contents(STATE_PATH);
        $request_array = json_decode($request, true);
        $states = $request_array['objects']['state'];
        $states_name = array_column($states, 'name');
        return $states_name;
    }
    
public function get_services()
{
    $services_name = []; 
    $request = file_get_contents(SERVICE_PATH);
    $request_array = json_decode($request, true);

    if (isset($request_array['objects']['services']) && is_array($request_array['objects']['services'])) {
        $services = $request_array['objects']['services'];
        $services_name = array_column($services, 'name');
    } else {
        if (isset($request_array['objects']['state']) && is_array($request_array['objects']['state'])) {
            $services = $request_array['objects']['state'];
            $services_name = array_column($services, 'name');
        } else {
            $services_name = []; 
        }
    }

    return $services_name;
}
    
    public function ajax_get_state()
    {
        add_action('admin_footer', function () {
        ?>
            <script>
                (function($) {
                    $('#wc_chabok_store_state').change(function() {
                        var option = "";
                        $('#wc_chabok_store_city').html(option);
                        $("#wc_chabok_store_city").prop("disabled", true);
                        var state = $(this).find(':selected').val();
                        var no = parseInt(state) + 1;
                        $.ajax({
                            url: '<?php echo admin_url('admin-ajax.php'); ?>',
                            type: "post",
                            dataType: "json",
                            data: {
                                action: "get_cities",
                                no: no,
                            },
                            success: function(response) {
                                response.forEach(element => {
                                    option += "<option value='" + element['name'] + "'>" + element["name"] + "</option>";
                                });

                                $("#wc_chabok_store_city").prop("disabled", false);
                                $('#wc_chabok_store_city').append(option);
                                var city_name = $('#wc_chabok_store_city_name').val();
                                $('#wc_chabok_store_city option[value="' + city_name + '"]').prop('selected', true);
                                $('#wc_chabok_store_city').change()
                            }
                        });
                    });

                })(jQuery);
            </script>
        <?php
        });
    }
    
    public function get_cities()
    {
        $request = file_get_contents(ADMIN_CITY_PATH);
        $request_array = json_decode($request, true);
        $cites = $request_array['objects']['city'];
        $cities = array_column($cites, 'name');
        
        if (isset($_POST['no'])) {
            wp_die(json_encode( $cites ));
        } else {
            return $cities;
        }
        
    }

    function find_city($city_name)
    {
        $request = file_get_contents(CITY_PATH);
        $request_array = json_decode($request, true);

        foreach ($request_array as $province => $cities) {
            $city_col = array_search($city_name, array_column($cities, 'name'));

            if ($city_col !== false && $cities[$city_col]['name'] == $city_name ) {
                return $cities[$city_col]['chbkCode']; 
            }
        }

        return null; 
    }

    public function ajax_get_city()
    {
        add_action('wp_footer', function () {
        ?>
            <script>
                (function($) {
                    if ($('#billing_city').is("select")) {
                        $('#billing_city').change(function() {
                            var city = $(this).find(':selected').text();
                            if (city !== '' && city.length > 0) {
                                $.ajax({
                                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                                    type: "post",
                                    dataType: "json",
                                    data: {
                                        action: "get_quote",
                                        city: city,
                                    },
                                    success: function(response) {
                                        $(document.body).trigger("update_checkout");
                                    }
                                });
                            }
                        });  
                    }else{
                        $('#billing_city').blur(function() {
                            var city = $(this).val();   
                            if (city !== '' && city.length > 0) {
                                $.ajax({
                                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                                    type: "post",
                                    dataType: "json",
                                    data: {
                                        action: "get_quote",
                                        city: city,
                                    },
                                    success: function(response) {
                                        $(document.body).trigger("update_checkout");
                                    }
                                });
                            }
                        });
                    }
                })(jQuery);
            </script>
        <?php
        });
    }

    /**
     * send data in order recived ajax
     */
    public function send_order_to_chabok($order_id)
    {
        $current_shipping_method = WC()->session->get('chosen_shipping_methods')[0];
        $is_chabok_shipping_method = explode(':', $current_shipping_method)[0];

        $order = wc_get_order($order_id);
        $order_data = $order->get_data();

        if ((CHABOK_METHOD_ENABEL == 'yes' && $is_chabok_shipping_method == 'chabok_shipping_method') 
            || CHABOK_METHOD_ENABEL == 'no') {

            // order date
            $order_date_created = $order->get_date_paid('date_paid') ? $order->get_date_paid('date_paid')->date('Y-m-d') : $order_data['date_created']->date('Y-m-d');
            $order_total = $order_data['total'];
            $order_items  = $order->get_items();
            $total_qty    = 0;
            $total_weight = 0;
            $categories = '';
            foreach ($order_items as $item_id => $product_item) {
                $product_id    = $product_item['product_id'];
                $product = wc_get_product($product_id);
                if (!$product) continue;
                $product_weight  = $product->get_weight() ? $product->get_weight() : 1;
                $quantity        = $product_item->get_quantity();
                $total_qty      += $quantity;
                $total_weight   += floatval($product_weight * $quantity);
                $terms = get_the_terms($product->get_id(), 'product_cat');
                $categories .= reset($terms)->name . ' / ';
            }

            $order_fullname = $order_data['billing']['first_name'] . ' ' . $order_data['billing']['last_name'];
            $order_city = $order_data['billing']['city'];
            $city_no = $this->find_city($order_city);
            $order_phone = $order_data['billing']['phone'];
            $order_email = $order_data['billing']['email'];
            $order_address = $order_data['billing']['address_1'];
            $order_postcode = $order_data['billing']['postcode'];
            $order_note  = $order_data['customer_note'];

            $weight =  WEIGHT_UNIT_KILO == '1' ? $total_weight : $total_weight/1000;        // 1 is kilo and 0 is geram
            $total_price =  PRICE_CURRENCY_RIAL == '1' ? $order_total : $order_total*10;    // 1 is IRR and 0 is toman 
            
        ?>
            <script>
                (function($) {
                    // Send request
                    $.ajax({
                        url: '<?php echo admin_url('admin-ajax.php'); ?>',
                        type: "post",
                        dataType: "json",
                        data: {
                            action: "chabok_ajax",
                            reference: <?= json_encode($order_id); ?>,
                            date: <?= json_encode($order_date_created); ?>,
                            inv_value: <?= json_encode($total_price); ?>,
                            weight: <?= json_encode($weight); ?>,
                            person: <?= json_encode($order_fullname); ?>,
                            city_name: <?= json_encode($order_city); ?>,
                            city_no: <?= json_encode($city_no); ?>,
                            mobile: <?= json_encode($order_phone); ?>,
                            email: <?= json_encode($order_email); ?>,
                            address: <?= json_encode($order_address); ?>,
                            postcode: <?= json_encode($order_postcode); ?>,
                            content: <?= json_encode($categories); ?>,
                            note: <?= json_encode($order_note); ?>,
                        },
                    });
                })(jQuery);
            </script>
        <?php
        }
    }

    function chabok_ajax()
    {

        if (CHABOK_DELIVERY_ONLY_TEHRAN == 'yes' && $_POST['city_name'] <> 'تهران') return false;

        ob_start();
        $reference = $_POST['reference'] . '111' . rand(99, 999);
        $order_id = $_POST['reference'];
        $date = $_POST['date'];
        $value = $_POST['inv_value'];
        $person = $_POST['person'];
        $city_no = $_POST['city_no'];
        $mobile = $_POST['mobile'];
        $email = $_POST['email'];
        $address = $_POST['address'];
        $postcode = $_POST['postcode'];
        $weight = $_POST['weight'];
        $content = $_POST['content'];
        $note = $_POST['note'];


        switch (CHABOK_SERVICE_TYPE) {
            case '0':
                $service = "1";
                break;
            case '1':
                $service = "6";
                break;
            case '2':
                $service = "35";
                break;
            default:
                $service = null; // Or handle an unexpected value
                break;
        }

        $user = new stdClass();
        $user->username = CHABOK_USERNAME;
        $user->password = CHABOK_PASSWORD;

        $cn = new stdClass();
        $cn->reference = $reference;
        $cn->date = $date;
        $cn->assinged_pieces = 1;
        $cn->service = $service;
        $cn->value = $value;
        $cn->payment_term = 0;
        $cn->weight = $weight;  
        $cn->content = $content;   
        $cn->note = $note;

        $sender = new stdClass();
        $sender->person = STORE_NAME;
        $sender->city_no = $this->find_city(STORE_CITY);
        $sender->telephone = STORE_PHONE;
        $sender->mobile = STORE_PHONE;
        $sender->email = STORE_EMAIL;
        $sender->address = STORE_ADDRESS;

        $receiver = new stdClass();
        $receiver->person = $person;
        $receiver->city_no = $city_no;
        $receiver->telephone = $mobile;
        $receiver->mobile = $mobile;
        $receiver->email = $email;
        $receiver->address = $address;
        $receiver->postcode = $postcode;

        $bulk = array();
        $bulkItem = new stdClass();
        $bulkItem->cn = $cn;
        $bulkItem->sender = $sender;
        $bulkItem->receiver = $receiver;
        $bulk[] = $bulkItem;
  
        $data = new stdClass();
        $data->user = $user;
        $data->bulk = $bulk;  

        $json_data = json_encode($data);

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => CHABOK_API."/bulk_import",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_POSTFIELDS => array('input' => $json_data),
            CURLOPT_HTTPHEADER => array(
                "app-auth: aW9zX2N1c3RvbWVyX2FwcDpUUFhAMjAxNg==",
                "content-type: multipart/form-data;charset=utf-8",
                'Cookie: PHPSESSID=0uo8kk84t6is4h3u11qbuuh8d6'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $result = json_decode($response, true);

        if($result["result"]){
            $tracking = $result["objects"]["result"][0]["tracking"];
            update_post_meta($order_id, 'tracking_code_chabok', $tracking);
            update_post_meta($order_id, 'puiw_invoice_track_id', $tracking);
            update_post_meta($order_id, 'order_result_chabok', 'true');
            return true;
        }else{
            $msg = $result['message'];
            update_post_meta($order_id, 'error_api_chabok',  $msg );
            update_post_meta($order_id, 'order_result_chabok', 'false');
            return false;
        }
        
    }


    //calculate shipping price api
    public function get_quote()
    {

        $package    = [];
        $city       = $_POST['city']; 
        $origin     = $this->find_city(STORE_CITY);

        if(!$destination = $this->find_city($city)){
            $_SESSION['chabock_error'] = 'امکان ارسال سفارش به این شهر وجود ندارد';
            unset($_SESSION['chabock_price']);
            setcookie('chabock_price', '', time() - 3600, "/"); // Expire the price cookie

            // Set the error cookie
            setcookie('chabock_error', $_SESSION['chabock_error'], time() + (86400 * 30), "/");
            return;
        }

        $value =  PRICE_CURRENCY_RIAL == '1' ? WC()->cart->subtotal : WC()->cart->subtotal* 10;

        if(WC()->cart->cart_contents_weight != 0){
            $weight = WEIGHT_UNIT_KILO == '1' ?  WC()->cart->cart_contents_weight :  WC()->cart->cart_contents_weight/1000;
        }else{
            $weight = 1;
        }

        if($token = $this->login_chabok()){
        
            $data = new stdClass();
            $data->origin = $origin;
            $data->destination = $destination;
            $data->weight = $weight;
            $data->value = $value;
            $data->method = 1;
            $data->cod = 0; 

            $info = new stdClass();
            $info->order = $data;

            $json_data = json_encode($info);
            $input= array('input' => $json_data);

            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => CHABOK_API."/get_quote",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => $input,
                CURLOPT_HTTPHEADER => array(
                    "Auth: $token",
                    "Cookie: PHPSESSID=$token",
                    "Content-Type: multipart/form-data"
                ),
            ));

            $response = curl_exec($curl);
            $error = curl_error($curl);
            $status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            curl_close($curl);

            if ($error && $status_code !== 200) {
                var_dump($error);  
                return false;
            } else {
                $result = json_decode($response, true);
                if ($result['result']) {
                    $price = $result["objects"]["order"]["quote"];
                    $price = get_woocommerce_currency() == 'IRT' ? intval($price) / 10 : $price;

                    // Set session and cookie for price
                    $_SESSION['chabock_price'] = $price;
                    setcookie('chabock_price', $price, time() + (86400 * 30), "/");

                    // Clear error cookie if it exists
                    unset($_SESSION['chabock_error']);
                    setcookie('chabock_error', '', time() - 3600, "/"); // Expire the error cookie
                } else {
                    $_SESSION['chabock_error'] = $result["message"];
                    unset($_SESSION['chabock_price']);
                    setcookie('chabock_price', '', time() - 3600, "/"); // Expire the price cookie

                    // Set the error cookie
                    setcookie('chabock_error', $_SESSION['chabock_error'], time() + (86400 * 30), "/");
                    $msg = $result['message'];
                    echo $msg;
                }
            }
        }
    }
   
    public function login_chabok()
    {
		
        $user = new stdClass();
        $user->username = CHABOK_USERNAME;
        $user->password = CHABOK_PASSWORD;

        $data = new stdClass();
        $data->user = $user;
           
        $json_data = json_encode($data);

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL =>  CHABOK_API . "/login?input=" . urlencode($json_data),
            CURLOPT_RETURNTRANSFER => true,
			CURLOPT_POST => true,
        ));

        $response = curl_exec($curl);
        $error = curl_error($curl);
		$status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);

        if ($error && $status_code !== 200) {
			var_dump($error);  
			return false;
		} else {
			$result = json_decode($response, true);
			if($result['result']){
                $token = $result["objects"]["user"]["token"];
                return $token;
			}else{
				$msg = $result['message'];
                return false;
            }

		}

    }
    public function show_tracking_code_in_order($order)
    {
        $order_id = $order->get_id();
        global $PeproUltimateInvoice;
        $generator = $PeproUltimateInvoice->barcode;

        $trackingCode = get_post_meta($order_id, 'tracking_code_chabok', true);
        $errorApiMessage = get_post_meta($order_id, 'error_api_chabok', true);

        if ($trackingCode) {
            echo '<strong>شماره بارنامه</strong>';   
            
            if (is_plugin_active('pepro-ultimate-invoice/pepro-ultimate-invoice.php')) {
                $src = 'data:image/jpeg;base64,' . base64_encode($generator->getBarcode($trackingCode, $generator::TYPE_CODE_128));
                echo '<img alt="" class="barcode" style="width:150px;height:auto;display:block" src="' . $src . '">';
            }

            echo '<span style="text-align:center">' . esc_html($trackingCode) . '</span>';
            return;
        }

        if ($errorApiMessage && !$trackingCode) {
            echo '<div style="padding: 10px; color: #000; font-size: 15px; line-height: 20px;">
                    <strong>بارنامه چابک دریافت نشد!</strong><br>
                    <span style="text-align:center; color: red">' . esc_html($errorApiMessage) . '</span>
                </div>';
            return;
        }
    }

    public function admin_scripts()
    {
        ?>
        <script>
            (function($) {
                $('#wc_chabok_store_city').change(function() {
                    var x = $(this).find(':selected').text();
                    $('#wc_chabok_store_city_name').val(x);
                    $('#wc_chabok_store_city_name').attr('value', x);
                });

                $('select#wc_chabok_store_state').change();
            })(jQuery);
        </script>
        <?php
    }
}

//Get Service File and save  in root plugin
if (file_exists(SERVICE_PATH)) {
    $chabok_WC = new Chabok_WC;
} else {
    
    add_action('admin_menu', 'add_custom_submenu_page');
    function add_custom_submenu_page() {
        add_submenu_page(
            'woocommerce',                 
            'دریافت تنظیمات چابک',       
            'دریافت تنظیمات چابک',              
            'manage_options',          
            'chabok-config',        
            'chabok_config_page_content' 
        );
    }
    
    function chabok_config_page_content() {
        ?>
        <div class="wrap">
            <h1>دریافت سرویس های چابک</h1>
            <p>برای دریافت بر روی دکمه زیر کلیک کنید</p>
        </div>
        
        <form method="POST">
            <input type="text" name="wc_chabok_api" placeholder="آدرس Api"  style="width: 35%;"/>
            <input type="submit" class="button-primary" name="call_chabock_config"  value="دانلود فایل های مورد نیاز چابک" style="background: green;">
        </form>
        <?php
    
       if (isset($_POST['wc_chabok_api']) && isset($_POST['wc_chabok_api']) && !is_null($_POST['wc_chabok_api'])) {
                
            $api = sanitize_text_field($_POST['wc_chabok_api']);

            $url = "$api/get_service";

            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, $url);

            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_TIMEOUT, 150); // Increase the timeout value (in seconds)
   
            $response = curl_exec($curl);

            $http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            curl_close($curl);

            if ($http_status == 200) {
                $res_service = file_put_contents(SERVICE_PATH_NEW.'/service.json', $response);
                if ($res_service) {
                    wp_safe_redirect(admin_url('admin.php?page=wc-settings&tab=chabok_settings'));
                } else {
                    wp_send_json_error(array('error' => 'Error saving service data'));
                }
            } else {
                wp_send_json_error(array('error' => 'Error getting service data'));
            }
        }
    }  
}